import numpy as np
from myPDB import myPDB
def parseTBL(fname,cidr,cidc):
    """
    Parse the *contacts.tbl file generated by PSAIA
    fname: name of the .tbl file
    cidr: chain id of the ligand
    cidc: chain id of the receptor
    returns:
        'r' and 'c' are two lists of the same size such that
        r[i],c[i] is the pair of residues (r[i] from ligan and c[i] from receptor)
        that are within the distance threshold used for generating the .tbl 
        c: 
    """
    r=[]
    c=[]    
    for l in open(fname, "r"):
        ls=l.split()
        #print ls
        if len(ls)==7:
            if ls[0]==cidr and ls[3]==cidc:
                r.append(int(ls[1]))
                c.append(int(ls[4]))
    return (r,c)

def getTBLMtx(Mvshape,r,c):
    Ml2=np.zeros(Mvshape)
    for i in range(len(r)):
        if r[i]<Mvshape[0] and c[i]<Mvshape[1]:
            Ml2[r[i],c[i]]=1.0
    return Ml2
def parseShandar(Mvshape,fname,lfname,rfname):
    """
    Returns an interaction matrix (Ms) for the prediction file generated
    by Shandar's PPiPP.
        Mvshape: shape of the interaction matrix 
        fname: name of PPiPP prediction file
        lfname: path to the ligand .pdb.pkl file whose sequence was used
        rfname: path to the receptor .pdb.pkl file whose sequence was used
        
    """
    L=myPDB.loader(lfname)
    R=myPDB.loader(rfname)
    Ms=np.zeros(Mvshape)
    Ms.fill(np.nan)
    for ln in open(fname, "r"):
        lns=ln.split(':')
        if len(lns)!=3:
            continue
        lidx=int(lns[0][1:])-1
        ridx=int(lns[1][1:])-1
        v=float(lns[2])
        (_,_,_,(_,lidx,_))=L.R[L.S2Ri[lidx]].get_full_id()
        (_,_,_,(_,ridx,_))=R.R[R.S2Ri[ridx]].get_full_id()
        Ms[lidx,ridx]=v
    return Ms
        
        
        
        