# -*- coding: utf-8 -*-
"""
Created on Mon Dec  3 16:12:44 2012

@author: root
"""

#given a folder of profiles, compute their ASA and rASA using SPINEX

from stride import getMAXASA
from BISEPutils import getFileParts
import os
import tempfile
import numpy as np
import pdb
def parseSpineXout(ofname):
    """
    given the output file generated by SPINEX, it returns the relevant stats in it
    
    """
#       0       1   2   3       4        5          6        7       8          9         10         11             12
# #     index  AA  SS   phi1    psi1     P_E       P_C       P_H     phi0      psi0       ASA        S_pk         S_SS      pk_phi       pk_psi     pkc_phi       pkc_ps
#        1    E   C   -85.6   141.3    0.0527   0.8784    0.0689     -87.5     143.0    130.5       0.6941       0.4126      -5.0000       5.0000       0.9924       0.2499
    ss=[]
    phi=[]
    psi=[]
    asa=[]
    rasa=[]
    MAX_ACC=getMAXASA('single')
    for f in open(ofname,'r'):
        f=f.split()
        if f[0]=='#':
            continue
        #ss.append(f[2])
        phi.append([float(f[8]),float(f[3])])
        psi.append([float(f[9]),float(f[4])])
        ss.append([float(i) for i in f[5:8]])
        asa.append(float(f[10]))
        try:
            m=MAX_ACC[f[1]] #if key not found then produce nan
        except KeyError as e:
            print e
            m=np.nan
            continue
        rasa.append(float(f[10])/m)
    return (np.array(asa),np.array(rasa),np.array(ss),np.array(phi),np.array(psi))
    
#cdirpath=sys.path[0] #curent directory used for temporarily storing the output file
def pssm_to_spinex(pfname,SPXEXE='spX.pl'):
    """
    Given the PSSM file (from processBLASTPGP.py) it predicts the ASA and rASA
    using SPINEX
    """
    (pdir,cname,ext)=getFileParts(pfname)
    out_file = tempfile.NamedTemporaryFile(suffix='.spx')
    out_file.close()
    listfile=out_file.name
    (cdirpath,_,_)=getFileParts(listfile)
    ofname=os.path.join(cdirpath,cname+'.spXout')
    lfh=open(listfile,'w+')
    lfh.write(cname)
    lfh.close()
    #pdb.set_trace()
    if os.system("%s %s %s %s" % (SPXEXE, listfile, pdir,cdirpath))==0:        
        z=parseSpineXout(ofname)
        os.remove(ofname)
    else:
        print "Error using spinex!"
        z=None
    os.remove(listfile)
    return z
    
if __name__=='__main__':
    pfname='/media/sf_Desktop/Shandar/Profile/1SBB_l_u.mat'
    (asa,rasa,ss,phi,psi)=pssm_to_spinex(pfname)